#ifndef C_IMPLEMENT_ENUM_HASH_H
#define C_IMPLEMENT_ENUM_HASH_H

#include <cstdio>
#include <list>
#include <vector>
#include <iostream>

#include "SuperFastHash.h"

using namespace std;

typedef unsigned int uint;
#define UINT_NULL 0x7fffffff

class EnumHashTable {
  vector< uint > id2head;   // point to the actual address (ie, 6*head_loc)
  list< uint > free_id;
  vector< uint > b;         // 6 form a block (left0, right1, prev2, next3, id4, content5); store the actual address
  list< uint > free_b;      // point to the freed address in b
  uint* h;                  // actual hash table (store the actual address of the first block in each hash bucket)
  uint hash_size;
public:
  EnumHashTable(uint init_nid = 1024, uint init_nb = 65535, uint _hash_size = 999983);
  ~EnumHashTable();

  uint new_id();
  bool del_id(uint k);

  uint new_b();
  bool del_b(uint k);

  uint find(uint id, uint c, uint& hash);
  bool insert_(uint id, uint c, uint hash);           // need to be called AFTER new_id(id)
  // known beforehand to insert at hash location (via find). must be the case that it was not originally there.
  bool insert_no_duplicate(uint id, uint c);           // need to be called AFTER new_id(id)
  bool delete_(uint b_it);

  inline uint head(uint id) {
    return id2head[id];
  }

  inline bool more_than_one_elem(uint id) {
    if (id2head[id] == UINT_NULL)
      return false;
    else
      return (b[id2head[id] + 1] != UINT_NULL);
  }
  
  inline uint bit2c(uint b_it) {
    return b[b_it + 5];
  }
  
  inline uint bit2next(uint b_it) {
    return b[b_it + 3];
  }
  
  inline uint bit2right(uint b_it) {
    return b[b_it + 1];
  }

  void move_from_id_to_id(uint from_id, uint to_id);

  bool clear(uint id);

  void print_id_all_c(uint id);
};

#endif //C_IMPLEMENT_ENUM_HASH_H
